<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\DiscountMaster;
use Carbon\Carbon;

class InactivateExpiredDiscounts extends Command
{
    protected $signature = 'discounts:inactivate-expired';
    protected $description = 'Set Dis_Status = I for expired discounts';

    public function handle()
    {
        $now = Carbon::now();

        // Update all discounts where En_Date has passed and Dis_Status is not already 'I'
        $expiredDiscounts = DiscountMaster::where('En_Date', '<', $now)
            ->where('Dis_Status', '!=', 'I')
            ->update(['Dis_Status' => 'I']);

        $this->info("Expired discounts updated to inactive: $expiredDiscounts");
    }
}
