<?php

namespace App\Http\Controllers;

use App\Models\CashCollection;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CashCollectionController extends Controller
{
      public function index()
    {
        return response()->json(CashCollection::with(['sender', 'receiver'])->get());
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'send_id' => 'required|exists:user_masters,U_Id',
            'receive_id' => 'required|exists:user_masters,U_Id',
            'amount' => 'required|numeric|min:0',
            'status' => 'required|in:0,1,2',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $cash = CashCollection::create($validator->validated());
        return response()->json($cash, 201);
    }

    public function show($id)
    {
        $cash = CashCollection::with(['sender', 'receiver'])->findOrFail($id);
        return response()->json($cash);
    }

    public function update(Request $request, $id)
    {
        $cash = CashCollection::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'send_id' => 'sometimes|exists:user_masters,U_Id',
            'receive_id' => 'sometimes|exists:user_masters,U_Id',
            'amount' => 'sometimes|numeric|min:0',
            'status' => 'sometimes|in:0,1,2',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $cash->update($validator->validated());
        return response()->json($cash);
    }

    public function destroy($id)
    {
        $cash = CashCollection::findOrFail($id);
        $cash->delete();
        return response()->json(['message' => 'Deleted successfully']);
    }
}
