<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class CategoryController extends Controller
{
    public function index()
    {
        try {
            $categories = Category::with('user')->get();
            return response()->json($categories);
        } catch (Exception $e) {
            return response()->json(['error' => 'Failed to fetch categories'], 500);
        }
    }

    public function store(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'Cat_Name' => 'required|string',
                'Cat_Des' => 'nullable|string',
                'U_ID'     => 'required|exists:user_masters,U_Id',
            ]);

            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()], 422);
            }

            $category = Category::create($validator->validated());

            return response()->json($category, 201);
        } catch (Exception $e) {
            return response()->json(['error' => 'Failed to create category'], 500);
        }
    }

    public function show($id)
    {
        try {
            $category = Category::with('user')->findOrFail($id);
            return response()->json($category);
        } catch (Exception $e) {
            return response()->json(['error' => 'Category not found'], 404);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $category = Category::findOrFail($id);

            $validator = Validator::make($request->all(), [
                'Cat_Name' => 'required|string',
                'Cat_Des'  => 'nullable|string',
                'U_ID'     => 'required|exists:user_masters,U_Id',
            ]);

            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()], 422);
            }

            $category->update($validator->validated());

            return response()->json($category);
        } catch (Exception $e) {
            return response()->json(['error' => 'Failed to update category'], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $category = Category::findOrFail($id);
            $category->delete();

            return response()->json(['message' => 'Deleted successfully']);
        } catch (Exception $e) {
            return response()->json(['error' => 'Failed to delete category'], 500);
        }
    }
}
