<?php

namespace App\Http\Controllers;

use App\Models\ComPackage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ComPackageController extends Controller
{
    // Get all records
    public function index()
    {
        return response()->json([
            'status' => true,
            'data' => ComPackage::all()
        ]);
    }

    // Store new record
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'U_Id' => 'required|exists:user_masters,U_Id',
            'St_Date' => 'required|date',
            'End_Date' => 'required|date|after_or_equal:St_Date',
            'U_Name' => 'required|string',
            'PackageId' => 'required|string',
            'PackageName' => 'required|string',
            'Package_Description' => 'nullable|string',
            'Package_Status' => 'required|string',
            'Package_MaxUsers' => 'required|string',
            'DT_Id' => 'required|string',
            'D_Id' => 'required|string',
            'Dis_Merge' => 'required|string',
            'PVT_Id' => 'required|string',
            'Final_Price' => 'required|string',
            'Total_Duration' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'message' => $validator->errors()], 422);
        }

        $comPackage = ComPackage::create($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Package created successfully.',
            'data' => $comPackage
        ]);
    }

    // Show specific package
    public function show($id)
    {
        $comPackage = ComPackage::find($id);

        if (!$comPackage) {
            return response()->json(['status' => false, 'message' => 'Package not found.'], 404);
        }

        return response()->json(['status' => true, 'data' => $comPackage]);
    }

    // Update package
    public function update(Request $request, $id)
    {
        $comPackage = ComPackage::find($id);

        if (!$comPackage) {
            return response()->json(['status' => false, 'message' => 'Package not found.'], 404);
        }

        $comPackage->update($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Package updated successfully.',
            'data' => $comPackage
        ]);
    }

    // Delete package
    public function destroy($id)
    {
        $comPackage = ComPackage::find($id);

        if (!$comPackage) {
            return response()->json(['status' => false, 'message' => 'Package not found.'], 404);
        }

        $comPackage->delete();

        return response()->json(['status' => true, 'message' => 'Package deleted successfully.']);
    }
}
