<?php

namespace App\Http\Controllers;

use App\Models\DisValType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DisValTypeController extends Controller
{
    public function index()
    {
        return response()->json(DisValType::all(), 200);
    }

    public function show($id)
    {
        try {
            $type = DisValType::findOrFail($id);
            return response()->json($type, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Discount value type not found'], 404);
        }
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'VT_Name' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $type = DisValType::create($request->all());
            return response()->json($type, 201);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to create discount value type'], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $type = DisValType::findOrFail($id);

            $validator = Validator::make($request->all(), [
                'VT_Name' => 'required|string',
            ]);

            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()], 422);
            }

            $type->update($request->all());
            return response()->json($type, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to update discount value type'], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $type = DisValType::findOrFail($id);
            $type->delete();
            return response()->json(['message' => 'Discount value type deleted'], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Discount value type not found'], 404);
        }
    }
}
