<?php

namespace App\Http\Controllers;

use App\Models\DiscountType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DiscountTypeController extends Controller
{
    public function index()
    {
        return response()->json(DiscountType::all(), 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Type_Name' => 'required|string'
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $type = DiscountType::create($request->all());
            return response()->json($type, 201);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Creation failed'], 500);
        }
    }

    public function show($id)
    {
        $type = DiscountType::find($id);
        if (!$type) {
            return response()->json(['message' => 'Type not found'], 404);
        }
        return response()->json($type, 200);
    }

    public function update(Request $request, $id)
    {
        $type = DiscountType::find($id);
        if (!$type) {
            return response()->json(['message' => 'Type not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'Type_Name' => 'required|string'
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $type->update($request->all());
            return response()->json($type, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Update failed'], 500);
        }
    }

    public function destroy($id)
    {
        $type = DiscountType::find($id);
        if (!$type) {
            return response()->json(['message' => 'Type not found'], 404);
        }

        try {
            $type->delete();
            return response()->json(['message' => 'Type deleted successfully'], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Deletion failed'], 500);
        }
    }
}
