<?php

namespace App\Http\Controllers;

use App\Models\DurationType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DurationTypeController extends Controller
{
    public function index()
    {
        return response()->json(DurationType::all(), 200);
    }

    public function show($id)
    {
        try {
            $data = DurationType::findOrFail($id);
            return response()->json($data, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Duration type not found'], 404);
        }
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Dur_Type' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $data = DurationType::create($request->all());
            return response()->json($data, 201);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to create duration type'], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $data = DurationType::findOrFail($id);

            $validator = Validator::make($request->all(), [
                'Dur_Type' => 'required|string',
            ]);

            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()], 422);
            }

            $data->update($request->all());
            return response()->json($data, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to update duration type'], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $data = DurationType::findOrFail($id);
            $data->delete();
            return response()->json(['message' => 'Duration type deleted'], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Duration type not found'], 404);
        }
    }
}
