<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Event;
use App\Models\UserMaster;
use Illuminate\Support\Facades\Validator;

class EventController extends Controller
{
    // List all events with full user data
    public function index()
    {
        $events = Event::with('user')->get();

        return response()->json([
            'status' => true,
            'message' => 'Event List Fetched Successfully',
            'data' => $events
        ], 200);
    }

    // Store new event
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'E_Name' => 'required|string',
            'U_Id' => 'required|exists:user_masters,U_Id',
            'E_Creater_Name' => 'required|string',
            'E_Creater_Mobile' => 'required|string',
            'E_StartDate' => 'required|date',
            'E_EndDate' => 'required|date',
            'E_StartTime' => 'required',
            'E_EndTime' => 'required',
            'E_Place' => 'required|string',
            'E_Description' => 'nullable|string',
            'E_State' => 'required|string',
            'E_City' => 'required|string',
            'E_Address' => 'required|string',
            'E_Capacity' => 'required|integer',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'Validation Error',
                'errors' => $validator->errors()
            ], 422);
        }

        $event = Event::create($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Event Created Successfully',
            'data' => $event
        ], 201);
    }

    // Show a single event with user details
    public function show($id)
    {
        $event = Event::with('user')->find($id);

        if (!$event) {
            return response()->json([
                'status' => false,
                'message' => 'Event Not Found'
            ], 404);
        }

        return response()->json([
            'status' => true,
            'message' => 'Event Fetched Successfully',
            'data' => $event
        ], 200);
    }

    // Update event
    public function update(Request $request, $id)
    {
        $event = Event::find($id);

        if (!$event) {
            return response()->json([
                'status' => false,
                'message' => 'Event Not Found'
            ], 404);
        }

        $event->update($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Event Updated Successfully',
            'data' => $event
        ], 200);
    }

    // Delete event
    public function destroy($id)
    {
        $event = Event::find($id);

        if (!$event) {
            return response()->json([
                'status' => false,
                'message' => 'Event Not Found'
            ], 404);
        }

        $event->delete();

        return response()->json([
            'status' => true,
            'message' => 'Event Deleted Successfully'
        ], 200);
    }
}
