<?php

namespace App\Http\Controllers;
use App\Models\Notice;
use App\Models\UserMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class NoticeController extends Controller
{
    public function index()
    {
        $notices = Notice::with('user')->get();
        return response()->json(['data' => $notices], 200);
    }

    public function store(Request $request)
    {
        // Validate request
        $validator = Validator::make($request->all(), [
            'N_Title' => 'required|string|max:255',
            'N_Category' => 'nullable|string|max:255',
            'N_MaleName' => 'nullable|string|max:255',
            'N_WomanName' => 'nullable|string|max:255',
            'N_Date' => 'nullable|date',
            'N_Age' => 'nullable|integer',
            'N_Years' => 'nullable|integer',
            'N_Mobile' => 'nullable|string|max:15',
            'N_Email' => 'nullable|email|max:255',
            'N_Address' => 'nullable|string',
            'N_Description' => 'nullable|string',
            'N_Image' => 'nullable|array',
            'U_Id' => 'required|exists:user_masters,U_Id',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        // Check if the user with provided U_Id has Role_Id = 2
        $user = UserMaster::where('U_Id', $request->U_Id)->first();
        if (!$user || $user->Role_Id != 2) {
            return response()->json(['error' => 'Unauthorized. Only users with Role_Id 2 can post notices.'], 403);
        }

        $notice = Notice::create($request->all());
        return response()->json(['data' => $notice, 'message' => 'Notice created successfully'], 201);
    }

    public function show($id)
    {
        // Find the notice by ID
        $notice = Notice::find($id);

        if (!$notice) {
            return response()->json(['error' => 'Notice not found'], 404);
        }

        return response()->json([
            'data' => $notice,
            'message' => 'Notice retrieved successfully'
        ], 200);
    }

    public function update(Request $request, $id)
    {
        $notice = Notice::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'N_Title' => 'sometimes|required|string|max:255',
            'N_Category' => 'nullable|string|max:255',
            'N_MaleName' => 'nullable|string|max:255',
            'N_WomanName' => 'nullable|string|max:255',
            'N_Date' => 'nullable|date',
            'N_Age' => 'nullable|integer',
            'N_Years' => 'nullable|integer',
            'N_Mobile' => 'nullable|string|max:15',
            'N_Email' => 'nullable|email|max:255',
            'N_Address' => 'nullable|string',
            'N_Description' => 'nullable|string',
            'N_Image' => 'nullable|array',
            'U_Id' => 'sometimes|required|exists:user_masters,U_Id',
        ]);


        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $notice->update($request->all());
        return response()->json(['data' => $notice, 'message' => 'Notice updated successfully'], 200);
    }

    public function destroy($id)
    {
        $notice = Notice::findOrFail($id);
        $notice->delete();
        return response()->json(['message' => 'Notice deleted successfully'], 200);
    }
}




