<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PackageDiscount;

class PackageDiscountController extends Controller
{
    public function index()
    {
        return PackageDiscount::with(['package', 'discount'])->get();
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'PackageId' => 'required|exists:package_masters,PackageId',
            'D_Id' => 'nullable|exists:discount_masters,D_Id',
        ]);

        $pd = PackageDiscount::create($validated);

        return response()->json($pd, 201);
    }

    public function show($id)
    {
        return PackageDiscount::with(['package', 'discount'])->findOrFail($id);
    }

    public function update(Request $request, $id)
    {
        $pd = PackageDiscount::findOrFail($id);

        $validated = $request->validate([
            'PackageId' => 'required|exists:package_masters,PackageId',
            'D_Id' => 'nullable|exists:discount_masters,D_Id',
        ]);

        $pd->update($validated);

        return response()->json($pd);
    }

    public function destroy($id)
    {
        $pd = PackageDiscount::findOrFail($id);
        $pd->delete();

        return response()->json(['message' => 'Deleted successfully']);
    }
}

