<?php

namespace App\Http\Controllers;

use App\Models\PackageFeature;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PackageFeatureController extends Controller
{
    public function index()
    {
        return response()->json(PackageFeature::all(), 200);
    }

    public function show($id)
    {
        try {
            $feature = PackageFeature::findOrFail($id);
            return response()->json($feature, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Feature not found'], 404);
        }
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Package_Fea_Name' => 'required|string',
            'Package_Fea_Description' => 'nullable|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $feature = PackageFeature::create($request->all());
            return response()->json($feature, 201);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to create feature'], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $feature = PackageFeature::findOrFail($id);

            $validator = Validator::make($request->all(), [
                'Package_Fea_Name' => 'required|string',
                'Package_Fea_Description' => 'nullable|string',
            ]);

            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()], 422);
            }

            $feature->update($request->all());
            return response()->json($feature, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to update feature'], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $feature = PackageFeature::findOrFail($id);
            $feature->delete();
            return response()->json(['message' => 'Feature deleted'], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Feature not found'], 404);
        }
    }
}
