<?php

namespace App\Http\Controllers;

use App\Models\PriceMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PriceMasterController extends Controller
{
    public function index()
    {
        return response()->json(PriceMaster::all(), 200);
    }

    public function show($id)
    {
        try {
            $data = PriceMaster::findOrFail($id);
            return response()->json($data, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Price type not found'], 404);
        }
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Pri_Type' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $data = PriceMaster::create($request->all());
            return response()->json($data, 201);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to create price type'], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $data = PriceMaster::findOrFail($id);

            $validator = Validator::make($request->all(), [
                'Pri_Type' => 'required|string',
            ]);

            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()], 422);
            }

            $data->update($request->all());
            return response()->json($data, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to update price type'], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $data = PriceMaster::findOrFail($id);
            $data->delete();
            return response()->json(['message' => 'Price type deleted'], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Price type not found'], 404);
        }
    }
}
