<?php

namespace App\Http\Controllers;

use App\Models\PriceTypeValue;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PriceTypeValueController extends Controller
{
    public function index()
    {
        return response()->json(PriceTypeValue::all(), 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'PT_Id' => 'required|integer',
            'Price_Value' => 'required|string|max:255',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $pvt = PriceTypeValue::create($request->all());
            return response()->json(['message' => 'Price Type Value created successfully.', 'data' => $pvt], 201);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to create Price Type Value.'], 500);
        }
    }

    public function show($id)
    {
        $pvt = PriceTypeValue::find($id);
        if (!$pvt) {
            return response()->json(['error' => 'Record not found.'], 404);
        }
        return response()->json($pvt, 200);
    }

    public function update(Request $request, $id)
    {
        $pvt = PriceTypeValue::find($id);
        if (!$pvt) {
            return response()->json(['error' => 'Record not found.'], 404);
        }

        $validator = Validator::make($request->all(), [
            'PT_Id' => 'sometimes|integer',
            'Price_Value' => 'sometimes|string|max:255',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $pvt->update($request->all());
            return response()->json(['message' => 'Price Type Value updated.', 'data' => $pvt], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Update failed.'], 500);
        }
    }

    public function destroy($id)
    {
        $pvt = PriceTypeValue::find($id);
        if (!$pvt) {
            return response()->json(['error' => 'Record not found.'], 404);
        }

        try {
            $pvt->delete();
            return response()->json(['message' => 'Price Type Value deleted.'], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Deletion failed.'], 500);
        }
    }
}
