<?php

namespace App\Http\Controllers;

use App\Models\RoleMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class RoleMasterController extends Controller
{
    // Get all roles
    public function index()
    {
        try {
            $roles = RoleMaster::all();
            return response()->json($roles);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    // Store new role
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Role_Name' => 'required|string|unique:role_masters,Role_Name',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $role = RoleMaster::create([
                'Role_Name' => $request->Role_Name,
            ]);
            return response()->json(['message' => 'Role created successfully', 'data' => $role], 201);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Something went wrong', 'details' => $e->getMessage()], 500);
        }
    }

    // Show single role
    public function show($id)
    {
        try {
            $role = RoleMaster::findOrFail($id);
            return response()->json($role);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Role not found'], 404);
        }
    }

    // Update role
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'Role_Name' => 'required|string|unique:role_masters,Role_Name,' . $id . ',Role_Id',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        try {
            $role = RoleMaster::findOrFail($id);
            $role->update(['Role_Name' => $request->Role_Name]);
            return response()->json(['message' => 'Role updated successfully', 'data' => $role]);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Something went wrong', 'details' => $e->getMessage()], 500);
        }
    }

    // Delete role
    public function destroy($id)
    {
        try {
            $role = RoleMaster::findOrFail($id);
            $role->delete();
            return response()->json(['message' => 'Role deleted successfully']);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Role not found or cannot delete'], 404);
        }
    }
}
