<?php

namespace App\Mail;

use App\Models\ScheduleDemo;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ScheduleApprovedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $schedule;

    public function __construct(ScheduleDemo $schedule)
    {
        $this->schedule = $schedule;
    }

    public function build()
    {
        return $this->subject('Your Demo Schedule has been Approved ✅')
            ->view('emails.schedule_approved');
    }
}
