<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AdditionalPeople extends Model
{
    protected $table = 'additional_people'; // Table name
    protected $fillable = ['BE_Id', 'name', 'email', 'mobile']; // Mass assignable fields

    /**
     * Relationship with BookEvent
     */
    public function booking()
    {
        return $this->belongsTo(BookEvent::class, 'BE_Id', 'BE_Id');
    }
}
