<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BookEvent extends Model
{
    protected $table = 'book_events';
    protected $primaryKey = 'BE_Id';
    protected $fillable = ['BE_Name', 'BE_Email', 'BE_Mobile', 'E_Id', 'U_Id', 'BE_Code'];

    /**
     * Relationship with AdditionalPeople
     */
    public function additionalPeople()
    {
        return $this->hasMany(AdditionalPeople::class, 'BE_Id', 'BE_Id');
    }

    // Other relationships (event, user, committee) remain unchanged
    public function event()
    {
        return $this->belongsTo(Event::class, 'E_Id', 'E_Id');
    }

    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id', 'U_Id');
    }
}
