<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CashCollection extends Model
{
    use HasFactory;

    // Explicit table name
    protected $table = 'cash_collections';

    // Custom primary key
    protected $primaryKey = 'Cash_ID';

    // Allow mass assignment
    protected $fillable = [
        'send_id',
        'receive_id',
        'amount',
        'status',
    ];

    // Relationships
    public function sender()
    {
        return $this->belongsTo(UserMaster::class, 'send_id', 'U_Id');
    }

    public function receiver()
    {
        return $this->belongsTo(UserMaster::class, 'receive_id', 'U_Id');
    }
}