<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Condolences extends Model
{
    use HasFactory;

    protected $table = 'condolences';
    protected $primaryKey = 'N_Id';

    protected $fillable = [
        'N_Title',
        'N_Category',
        'N_MaleName',
        'N_WomanName',
        'N_Date',
        'N_Age',
        'N_Years',
        'N_Mobile',
        'N_Email',
        'N_Address',
        'N_Description',
        'N_Image',
        'N_Status',
        'U_Id'
    ];

    protected $casts = [
        'N_Image' => 'array', // For handling JSON images
        'N_Date' => 'date'
    ];

    // 🎯 Relationship with user_master
    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id', 'U_Id');
    }
}
