<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DiscountMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'D_Id';
    protected $table = 'discount_masters';

    protected $fillable = [
        'D_Name',
        'St_Date',
        'En_Date',
        'DT_Id',
        'DVT_Id',
        'Dic_Value',
        'quentity',
    ];

    protected $casts = [
        'St_Date' => 'date',
        'En_Date' => 'date',
        'quentity' => 'integer',
    ];


    public function discountType()
    {
        return $this->belongsTo(DiscountType::class, 'DT_Id', 'DT_Id');
    }
    public function discountValueType()
    {
        return $this->belongsTo(DisValType::class, 'DVT_Id', 'DVT_Id');
    }
}
