<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'events';
    protected $primaryKey = 'E_Id';

    protected $fillable = [
        'E_Name',
        'E_Creater_Name',
        'E_Creater_Mobile',
        'U_Id',
        'E_StartDate',
        'E_EndDate',
        'E_StartTime',
        'E_EndTime',
        'E_Place',
        'E_Description',
        'E_State',
        'E_City',
        'E_Zipcode',
        'E_Address',
        'E_Fees',
        'E_Status',
        'E_Capacity',
        'E_Booked_Count'
    ];

    protected $dates = ['deleted_at', 'E_StartDate', 'E_EndDate'];

    protected static function boot()
    {
        parent::boot();

        static::retrieved(function ($event) {
            if ($event->E_Status === 'A') {
                $endDateTime = Carbon::parse($event->E_EndDate . ' ' . $event->E_EndTime);
                if ($endDateTime->isPast()) {
                    $event->E_Status = 'D';
                    $event->save();
                }
            }
        });

        static::updating(function ($event) {
            if (
                $event->isDirty('E_StartDate') || $event->isDirty('E_EndDate') ||
                $event->isDirty('E_StartTime') || $event->isDirty('E_EndTime')
            ) {
                $endDateTime = Carbon::parse($event->E_EndDate . ' ' . $event->E_EndTime);
                if ($event->E_Status === 'A' && $endDateTime->isPast()) {
                    $event->E_Status = 'D';
                }
            }
        });
    }

    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id', 'U_Id');
    }
}
