<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gallary extends Model
{
    use HasFactory;

    protected $table = 'gallary';

    protected $primaryKey = 'CE_Id';

    protected $fillable = [
        'CE_Name',
        'CE_Date',
        'CE_Place',
        'CE_Description',
        'CE_Photo',
        'U_Id'
    ];

    protected $casts = [
        'CE_Photo' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id', 'U_Id');
    }
}
