<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobApplication extends Model
{
    use HasFactory;

    protected $fillable = [
        'Name',
        'Mobile',
        'U_Id',
        'Job_Id',
        'Resume',
        'Description',
        'status'
    ];

    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id', 'U_Id');
    }

    public function job()
    {
        return $this->belongsTo(Job::class, 'Job_Id');
    }
}
