<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Login extends Model
{
    use HasFactory;
    protected $table = 'logins';
    protected $fillable = [
        'U_Id',
        'mobile',
        'email',
        'password',
    ];
    protected $hidden = [
        'password' // Hide password in API responses
    ];
    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id');
    }
}
