<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Marketplace extends Model
{
    use HasFactory, SoftDeletes; // ✅ Enable SoftDeletes
    protected $table = 'marketplaces';
    protected $primaryKey = 'M_Id';
    protected $fillable = [
        'M_Category',
        'M_Title',
        'M_Description',
        'M_Name',
        'M_Mobile',
        'M_Address',
        'M_Image',
        'M_Price',
        'M_Status',
        'Comm_Id',
        'U_Id'
    ];
    protected $dates = ['deleted_at'];
    protected $casts = [
        'M_Image' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id', 'U_Id');
    }
}
