<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notice extends Model
{
    use HasFactory;

    protected $primaryKey = 'N_Id';
    protected $table = "notices";
    protected $fillable = [
        'N_Title',
        'N_Category',
        'N_MaleName',
        'N_WomanName',
        'N_Date',
        'N_Age',
        'N_Years',
        'N_Mobile',
        'N_Email',
        'N_Address',
        'N_Description',
        'N_Image',
        'U_Id'
    ];

    protected $casts = [
        'N_Image' => 'array',
    ];

    /**
     * Relationship with User Master
     */
    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id', 'U_Id');
    }
}
