<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OtpLog extends Model
{
    use HasFactory;
    protected $table = 'otp_log';
    protected $primaryKey = 'Veri_Seq';

    protected $fillable = [
        'U_Id',
        'OTP_Char',
        'OPT_Type',
        'OPT_Status',
        'SendingDate',
        'SendingTime',
        'ExpieryDate',
        'ExpieryTime',
    ];

    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'U_Id');
    }
}
