<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'PackageId';
    protected $table = 'package_masters';

    protected $fillable = [
        'PackageName',
        'Description',
        'Status',
        'MaxUsers',
        'Duration_Value',
        'DT_Id',
        'D_Id',
        'Dis_Merge',
        'PVT_Id',
        'Final_Price',
        'Total_Duration'
    ];

    // Many-to-many relationship with PackageFeature
    public function features()
    {
        return $this->belongsToMany(PackageFeature::class, 'package_feature_pivot', 'PackageId', 'Package_Fea_Id');
    }

    // Many-to-many relationship with DiscountMaster
    public function discounts()
    {
        return $this->belongsToMany(DiscountMaster::class, 'package_discount', 'PackageId', 'D_Id');
    }

    // One-to-many relationship with DurationType
    public function durationType()
    {
        return $this->belongsTo(DurationType::class, 'DT_Id', 'DT_Id');
    }

    // One-to-one relationship with PriceTypeValue
    public function priceType()
    {
        return $this->belongsTo(PriceTypeValue::class, 'PVT_Id', 'PVT_Id');
    }
}
