<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;

class UserMaster extends Model
{
    use SoftDeletes;

    protected $primaryKey = 'U_Id';
    protected $table = 'user_masters';

    protected $fillable = [
        'U_Name',
        'U_Email',
        'U_Password',
        'U_Mobile',
        'Role_Id',
        'PackageId',
        'Short_CommName',
        'Comm_Name',
        'Comm_Id',
        'P_Image',
        'Middle_Name',
        'Last_Name',
        'Address',
        'City',
        'State',
        'Country',
        'Zipcode',
        'Gender',
        'Occupation',
        'Marital_Status',
        'Education_School',
        'Education_College',
        'School_Name',
        'College_Name',
        'Occupation_Address',
        'DOB',
        'U_Status',
        'PAN_No',
        'Com_Regi_No'
    ];

    protected $hidden = ['U_Password'];

    /**
     * Get the role associated with the user.
     */
    public function role()
    {
        return $this->belongsTo(RoleMaster::class, 'Role_Id', 'Role_Id');
    }
    public function categories()
{
    return $this->hasMany(Category::class, 'U_ID', 'U_Id');
}

    /**
     * Get the package associated with the user.
     */
    public function package()
    {
        return $this->belongsTo(PackageMaster::class, 'PackageId', 'PackageId');
    }

    /**
     * Check if the user's package has expired and revert to default if needed.
     *
     * @param int $defaultPackageId
     * @return bool
     */
    public function checkAndUpdatePackageExpiration($defaultPackageId = 1)
    {
        if (!$this->package || !$this->package->durationType) {
            // If no package or duration type, revert to default
            $this->PackageId = $defaultPackageId;
            $this->save();
            return true;
        }

        $createdAt = Carbon::parse($this->created_at);
        $durType = $this->package->durationType->Dur_Type;
        $durValue = $this->package->durationType->Duration_Value;

        $expirationDate = match ($durType) {
            'Day' => $createdAt->addDays($durValue),
            'Month' => $createdAt->addMonths($durValue),
            'Year' => $createdAt->addYears($durValue),
            default => $createdAt, // No expiration for unknown types
        };

        if (Carbon::now()->greaterThan($expirationDate)) {
            // Package has expired, revert to default
            $this->PackageId = $defaultPackageId;
            $this->save();
            return true;
        }

        return false;
    }

     public function donations()
    {
        return $this->hasMany(Donation::class, 'U_ID', 'U_Id');
    }
}
