<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserMastersTable extends Migration
{
    public function up()
    {
        Schema::create('user_masters', function (Blueprint $table) {
            $table->bigIncrements('U_Id');
            $table->string('U_Name');
            $table->string('U_Email')->unique();
            $table->string('U_Password');
            $table->string('U_Mobile');
            $table->string('Short_CommName')->nullable();
            $table->string('Comm_Name')->nullable();
            $table->string('Comm_Id')->nullable();
            $table->unsignedBigInteger('Role_Id')->default(3);
            $table->foreign('Role_Id')->references('Role_Id')->on('role_masters')->onDelete('cascade');
            $table->tinyInteger('U_Status')->default(0)->comment('0: Pending, 1: Approved, 2: Rejected');
            $table->string('Middle_Name')->nullable();
            $table->string('Last_Name')->nullable();
            $table->string('Address')->nullable();
            $table->string('City')->nullable();
            $table->string('State')->nullable();
            $table->string('Country')->nullable();
            $table->string('Zipcode')->nullable();
            $table->enum('Gender', ['Male', 'Female', 'Other'])->nullable();
            $table->string('Occupation')->nullable();
            $table->enum('Marital_Status', ['Married', 'Single'])->nullable();
            $table->decimal('Education_School', 5, 2)->nullable(); // Percentage
            $table->decimal('Education_College', 5, 2)->nullable(); // CGPA
            $table->string('P_Image')->nullable(); // Profile Image
            $table->string('School_Name')->nullable();
            $table->string('College_Name')->nullable();
            $table->string('Occupation_Address')->nullable();
            $table->date('DOB')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('user_masters');
    }
}
