<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedule_demos', function (Blueprint $table) {
            $table->bigIncrements('sche_id');
            $table->string('sche_name');
            $table->string('sche_email');
            $table->string('sche_phone');
            $table->date('sche_date');
            $table->string('sche_time_slots');
            $table->text('additional_note')->nullable();
            $table->tinyInteger('sche_status')->default(0); // 0 = pending, 1 = approved, 2 = rejected
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedule_demos');
    }
};
