<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('price_type_values', function (Blueprint $table) {
            $table->id('PVT_Id');
            $table->unsignedBigInteger('PT_Id');
            $table->foreign('PT_Id')->references('PT_Id')->on('price_masters')->onDelete('cascade');
            $table->string('Price_Value');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('price_type_values');
    }
};
