<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('discount_masters', function (Blueprint $table) {
            $table->bigIncrements('D_Id');
            $table->string('D_Name');
            $table->date('St_Date');
            $table->date('En_Date');
            $table->unsignedBigInteger('DT_Id');
            $table->foreign('DT_Id')->references('DT_Id')->on('discount_types')->onDelete('cascade');
            $table->unsignedBigInteger('DVT_Id');
            $table->foreign('DVT_Id')->references('DVT_Id')->on('dis_val_types')->onDelete('cascade');
            $table->string('Dic_Value');
            $table->integer('quentity')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('discount_masters');
    }
};
