<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_masters', function (Blueprint $table) {
            $table->bigIncrements('PackageId');
            $table->string('PackageName');
            $table->longText('Description')->nullable();
            $table->enum('Status', ['A', 'D'])->default('A');
            $table->integer('MaxUsers')->default(0);
            $table->integer('Duration_Value');
            $table->unsignedBigInteger('DT_Id');
            $table->foreign('DT_Id')->references('DT_Id')->on('duration_types')->onDelete('cascade');
            $table->unsignedBigInteger('D_Id');
            $table->foreign('D_Id')->references('D_Id')->on('discount_masters')->onDelete('cascade');
            $table->integer('Dis_Merge');
            $table->unsignedBigInteger('PVT_Id');
            $table->foreign('PVT_Id')->references('PVT_Id')->on('price_type_values')->onDelete('cascade');
            $table->decimal('Final_Price', 10, 2);
            $table->timestamps();
        });

        Schema::create('package_feature_pivot', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('PackageId');
            $table->unsignedBigInteger('Package_Fea_Id');
            $table->foreign('PackageId')->references('PackageId')->on('package_masters')->onDelete('cascade');
            $table->foreign('Package_Fea_Id')->references('Package_Fea_Id')->on('package_features')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_feature_pivot');
        Schema::dropIfExists('package_masters');
    }
};
