<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_masters', function (Blueprint $table) {
            $table->unsignedBigInteger('PackageId')->nullable()->after('Role_Id')->default(1);
            $table->foreign('PackageId')->references('PackageId')->on('package_masters')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_masters', function (Blueprint $table) {
            $table->dropForeign(['PackageId']);
            $table->dropColumn('PackageId');
        });
    }
};
