<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('com_packages', function (Blueprint $table) {
            $table->bigIncrements('Com_P_Id');
            $table->unsignedBigInteger('U_Id');
            $table->date('St_Date');
            $table->date('End_Date');
            $table->string('U_Name');
            $table->string('PackageId');
            $table->string('PackageName');
            $table->string('Package_Description')->nullable();
            $table->string('Package_Status');
            $table->string('Package_MaxUsers');
            $table->string('DT_Id');
            $table->string('D_Id');
            $table->string('Dis_Merge');
            $table->string('PVT_Id');
            $table->string('Final_Price');
            $table->string('Total_Duration');
            $table->foreign('U_Id')->references('U_Id')->on('user_masters')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('com_packages');
    }
};
