<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gallary', function (Blueprint $table) {
            $table->bigIncrements('CE_Id');
            $table->string('CE_Name')->nullable();
            $table->date('CE_Date')->nullable();
            $table->string('CE_Place')->nullable();
            $table->text('CE_Description')->nullable();
            $table->longText('CE_Photo');
            $table->unsignedBigInteger('U_Id');
            $table->foreign('U_Id')->references('U_Id')->on('user_masters')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gallary');
    }
};
