<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('jobs', function (Blueprint $table) {
            $table->id();
            $table->string('Company_Name');
            $table->string('Job_Title');
            $table->text('Job_Description')->nullable();
            $table->string('website')->nullable();
            $table->unsignedBigInteger('U_Id');
            $table->foreign('U_Id')->references('U_Id')->on('user_masters')->onDelete('cascade');
            $table->enum('Status', ['open', 'close'])->default('open');
            $table->text('Location')->nullable();
            $table->string('City')->nullable();
            $table->string('State')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jobs');
    }
};
