<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('job_applications', function (Blueprint $table) {
            $table->id();
            $table->string('Name');
            $table->string('Mobile');
            $table->unsignedBigInteger('U_Id');
            $table->foreign('U_Id')->references('U_Id')->on('user_masters')->onDelete('cascade');
            $table->unsignedBigInteger('Job_Id');
            $table->foreign('Job_Id')->references('id')->on('jobs')->onDelete('cascade');
            $table->string('Resume');
            $table->text('Description')->nullable();
            $table->enum('status', ['pending', 'accepted', 'rejected'])->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('job_applications');
    }
};
