<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('condolences', function (Blueprint $table) {
            $table->bigIncrements('N_Id');
            $table->string('N_Title');
            $table->string('N_Category')->nullable();
            $table->string('N_MaleName')->nullable();
            $table->string('N_WomanName')->nullable();
            $table->date('N_Date')->nullable();
            $table->integer('N_Age')->nullable();
            $table->integer('N_Years')->nullable();
            $table->string('N_Mobile')->nullable();
            $table->string('N_Email')->nullable();
            $table->text('N_Address')->nullable();
            $table->text('N_Description')->nullable();
            $table->json('N_Image')->nullable();
            $table->enum('N_Status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->unsignedBigInteger('U_Id');
            $table->foreign('U_Id')->references('U_Id')->on('user_masters')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('condolences');
    }
};
