<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('marketplaces', function (Blueprint $table) {
            $table->id('M_Id');
            $table->enum('M_Category', [
                'Electronics',
                'Home Appliances',
                'Furniture',
                'Clothes',
                'Footwear',
                'Books',
                'Vehicles',
                'Real Estate',
                'Toys',
                'Sports',
                'Fitness',
                'Handicrafts',
                'Others'
            ]);
            $table->string('M_Title');
            $table->text('M_Description')->nullable();
            $table->string('M_Name');
            $table->string('M_Mobile');
            $table->string('M_Address');
            $table->json('M_Image');
            $table->decimal('M_Price', 10, 2);
            $table->enum('M_Status', ['Active', 'Inactive'])->default('Active');
            $table->unsignedBigInteger('U_Id');
            $table->softDeletes();
            $table->timestamps();
            $table->foreign('U_Id')->references('U_Id')->on('user_masters')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('marketplaces');
    }
};
