<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('events', function (Blueprint $table) {
            $table->bigIncrements('E_Id');
            $table->string('E_Name');
            $table->string('E_Creater_Name');
            $table->string('E_Creater_Mobile');
            $table->unsignedBigInteger('U_Id')->nullable();
            $table->unsignedBigInteger('Mam_Id')->nullable();
            $table->date('E_StartDate');
            $table->date('E_EndDate');
            $table->time('E_StartTime');
            $table->time('E_EndTime');
            $table->string('E_Place');
            $table->text('E_Description');
            $table->string('E_State')->nullable();
            $table->String('E_City')->nullable();
            $table->String('E_Zipcode')->nullable();
            $table->text('E_Address')->nullable();
            $table->bigInteger('E_Fees')->nullable();
            $table->char('E_Status')->default('P')->comment('P:Pending,A: Active, R: Reject,C:Cancalled,D:Done');
            $table->foreign('U_Id')->references('U_Id')->on('user_masters')->onDelete('cascade');
            $table->integer('E_Capacity');
            $table->integer('E_Booked_Count')->default(0);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('events');
    }
};
