<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('book_events', function (Blueprint $table) {
            $table->bigIncrements('BE_Id');
            $table->string('BE_Name');
            $table->string('BE_Email');
            $table->string('BE_Mobile');
            $table->unsignedBigInteger('E_Id');
            $table->unsignedBigInteger('U_Id');
            $table->string('BE_Code');
            $table->timestamps();

            $table->foreign('E_Id')->references('E_Id')->on('events')->onDelete('cascade');
            $table->foreign('U_Id')->references('U_Id')->on('user_masters')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('book_events');
    }
};
