<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('additional_people', function (Blueprint $table) {
            $table->bigIncrements('id'); // Primary key
            $table->unsignedBigInteger('BE_Id'); // Foreign key to book_events
            $table->string('name'); // Name of the additional person
            $table->string('email'); // Email of the additional person
            $table->string('mobile'); // Mobile number of the additional person
            $table->timestamps(); // Created_at and updated_at columns

            // Foreign key constraint linking to book_events
            $table->foreign('BE_Id')->references('BE_Id')->on('book_events')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('additional_people');
    }
};
