<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('otp_log', function (Blueprint $table) {
            $table->bigIncrements('Veri_Seq');
            $table->unsignedBigInteger('U_Id')->nullable();
            $table->string('OTP_Char', 6);
            $table->string('OPT_Type', 1);
            $table->string('OPT_Status', 1);
            $table->date('SendingDate');
            $table->string('SendingTime');
            $table->date('ExpieryDate');
            $table->string('ExpieryTime');
            $table->timestamps();
            $table->foreign('U_Id')->references('U_Id')->on('user_masters')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('otp_log');
    }
};
