<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id('Cat_id');
        $table->string('Cat_Name');
        $table->text('Cat_Des')->nullable();
        $table->unsignedBigInteger('U_ID');
        $table->timestamps();

        // Foreign key to user_masters table
        $table->foreign('U_ID')->references('U_Id')->on('user_masters')->onDelete('cascade');
    });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
