<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('donations', function (Blueprint $table) {
          $table->id('D_id');
        $table->string('D_name');
        $table->text('D_des')->nullable();
        $table->decimal('goal_amount', 10, 2);
        $table->decimal('mini_amount', 10, 2);
        $table->date('Start_date');
        $table->date('End_date');
        $table->enum('Pop_up', ['Y', 'N'])->default('N');
        $table->boolean('status')->default(0); // 0 = inactive

        // U_ID foreign key
        $table->unsignedBigInteger('U_ID');
        $table->foreign('U_ID')
              ->references('U_Id')
              ->on('user_masters')
              ->onDelete('cascade');

        $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('donations');
    }
};
