<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('donates', function (Blueprint $table) {
             $table->id('Do_id');
        $table->decimal('D_amount', 10, 2);
        $table->unsignedBigInteger('U_ID');
        $table->unsignedBigInteger('D_id');  // FK to donations table
        $table->date('Date');
        $table->timestamps();

        $table->foreign('U_ID')->references('U_Id')->on('user_masters')->onDelete('cascade');
        $table->foreign('D_id')->references('D_id')->on('donations')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('donates');
    }
};
