<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('donations', function (Blueprint $table) {
            $table->unsignedBigInteger('Cat_id')->nullable()->after('U_ID');

            $table->foreign('Cat_id')
                  ->references('Cat_id')
                  ->on('categories')
                  ->onDelete('set null'); // deletes the FK value, not the row
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('donations', function (Blueprint $table) {
              $table->dropForeign(['Cat_id']);
            $table->dropColumn('Cat_id');
        });
    }
};
