<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_discount', function (Blueprint $table) {
           $table->bigIncrements('id');
            $table->unsignedBigInteger('PackageId');
            $table->unsignedBigInteger('D_Id')->nullable();

            $table->foreign('PackageId')->references('PackageId')->on('package_masters')->onDelete('cascade');
            $table->foreign('D_Id')->references('D_Id')->on('discount_masters')->onDelete('set null');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_discount');
    }
};
